/******************************************************************************
 * Technical University of Technology Darmstadt
 * Industrial Process and System Communication
 * Project:  TCP
 * Filename: FSMWindow.java
 * Author:   Gunter Weiss
 * Contents: Places the panels in a Frame with GridBagLayout
 * Last Changes: Gunter Weiss 2/6/97
 *****************************************************************************/

import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Label;
import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Event;
import java.awt.Scrollbar;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Button;
import java.awt.Color;
import java.util.Vector;

/******************************************************************************
* Class: FSMWindow
* Description: organizes everything concerning the GUI.
******************************************************************************/
public class FSMWindow extends Frame {
  TcpStarter parent;
  Host h1, h2;
  Vector fsmhist = new Vector(100);
  MenuBar menub;
  Menu userlevelMenu, optionsMenu, screenMenu;
  MenuItem menuibeginner,menuiadvanced, menuiquit;
  MenuItem menuisize1, menuisize2, menuisize3, menuisize4;
  Dimension framedimension;
  Point frameposition;
  GridBagLayout gbl1 = new GridBagLayout();
  GridBagLayout gbl2 = new GridBagLayout();
  GridBagLayout gbl3 = new GridBagLayout();
  GridBagLayout gbl4 = new GridBagLayout();
  GridBagConstraints gbc = new GridBagConstraints();
  Font font1, font2, font3, font4;
  FSMStatePanel closedpanel, listenpanel, synsentpanel, synrcvdpanel, estabpanel,closewaitpanel;
  FSMStatePanel lastackpanel, finwait1panel, finwait2panel, closingpanel, timewaitpanel, closed2panel ;
  FSMStatePanel host1pan, host2pan;
  FSMArrowPanel panel0to1, panel1to2, panel2to31, panel2to32, panel1to3, panel3to4, panel2to4;
  FSMArrowPanel panel4to5, panel5to6, panel4to7, panel7to8, panel7to9, panel9to10, panel8to10;
  FSMArrowPanel panel7to10, panel10toright, panel6todown, panel2toright, panel0to21, panel0to22;
  FSMArrowPanel panel0to23, panel2to33, panel3to71, panel3to72, panel3to73;
  Label infotext;
  Button startbutton, stepbutleft, stepbutright;
  boolean advanced = false;
  boolean great = false;
  boolean show_bool = false;
  int counter1 = 0;
  int counter2 = 0;
  int length1,length2;
  protected int screenfactor = 1;
  String statush1,statush2;
  HTcpSegment newh1,newh2,oldh1,oldh2,fsmseg,oldseg;
  HTcpSegment dummy = new HTcpSegment();

  public FSMWindow(TcpStarter target, Host host1, Host host2) {
    this.parent = target;
    this.h1 = host1;
    this.h2 = host2;
    menub         = new MenuBar();
    userlevelMenu = new Menu( "Userlevel");
    optionsMenu   = new Menu( "Quit" );
    screenMenu    = new Menu( "Screen" );
    menuiquit     = new MenuItem( "Quit" );
    menuisize1    = new MenuItem( "640 x 480" );
    menuisize2    = new MenuItem( "800 x 600" );
    menuisize3    = new MenuItem( "1024 x 768" );
    menuisize4    = new MenuItem( "1280 x 1024" );
    optionsMenu.   add( menuiquit );
    screenMenu.    add( menuisize1 );
    screenMenu.    add( menuisize2 );
    screenMenu.    add( menuisize3 );
    screenMenu.    add( menuisize4 );
    menub. add( optionsMenu );
    menub. add( screenMenu );
    setMenuBar( menub );
    font1 = new Font( "font1", Font.ITALIC, 9  );
    font2 = new Font( "font2", Font.ITALIC, 15 );
    font3 = new Font( "font3", Font.ITALIC, 19 );
    font4 = new Font( "font4", Font.ITALIC, 24 );
    closedpanel    = new FSMStatePanel( this , 0, 0 );
    listenpanel    = new FSMStatePanel( this , 1, 0 );
    synsentpanel   = new FSMStatePanel( this , 2, 0 );
    synrcvdpanel   = new FSMStatePanel( this , 3, 0 );
    estabpanel     = new FSMStatePanel( this , 4, 0 );
    closewaitpanel = new FSMStatePanel( this , 5, 0 );
    lastackpanel   = new FSMStatePanel( this , 6, 0 );
    finwait1panel  = new FSMStatePanel( this , 7, 0 );
    finwait2panel  = new FSMStatePanel( this , 8, 0 );
    closingpanel   = new FSMStatePanel( this , 9, 0 );
    timewaitpanel  = new FSMStatePanel( this , 10,0 );
    closed2panel   = new FSMStatePanel( this , 0, 0 );
    host1pan       = new FSMStatePanel( this , 15,0 );
    host2pan       = new FSMStatePanel( this , 15,0 );
    panel0to1    = new FSMArrowPanel( this, 2,0);
    panel0to21   = new FSMArrowPanel( this, 1,0);
    panel0to22   = new FSMArrowPanel( this, 5,0);
    panel0to23   = new FSMArrowPanel( this, 2,0);
    panel1to2    = new FSMArrowPanel( this, 1,0);
    panel1to3    = new FSMArrowPanel( this, 3,0);
    panel2to31   = new FSMArrowPanel( this, 4,0);
    panel2to32   = new FSMArrowPanel( this, 4,0);
    panel2to33   = new FSMArrowPanel( this, 4,0);
    panel3to4    = new FSMArrowPanel( this, 1,0);
    panel2to4    = new FSMArrowPanel( this, 3,0);
    panel4to5    = new FSMArrowPanel( this, 0,0);
    panel5to6    = new FSMArrowPanel( this, 2,0);
    panel4to7    = new FSMArrowPanel( this, 3,0);
    panel7to8    = new FSMArrowPanel( this, 2,0);
    panel7to9    = new FSMArrowPanel( this, 0,0);
    panel9to10   = new FSMArrowPanel( this, 2,0);
    panel8to10   = new FSMArrowPanel( this, 0,0);
    panel7to10   = new FSMArrowPanel( this, 1,0);
    panel3to71   = new FSMArrowPanel( this, 2,0);
    panel3to72   = new FSMArrowPanel( this, 6,0);
    panel3to73   = new FSMArrowPanel( this, 2,0);
    panel10toright = new FSMArrowPanel( this, 0,0);
    panel6todown   = new FSMArrowPanel( this, 2,0);
    panel2toright  = new FSMArrowPanel( this, 0,0);
    startbutton  = new Button( "Start" );
    stepbutleft  = new Button( "next step" );
    stepbutright = new Button( "next step" );
    stepbutleft.disable();
    stepbutright.disable();



    // GridBagLayout declarations for 640x480 Pixels
    int rowHeights1[] = {20,20,20,60,20,60,20,60,20,60,20,60,20,20 };
    int columnWidths1[] = { 50,100,100,100,100,100,50 };
    double rowWeights1[] = { 0,0,0,0,0,0,0,0,0,0,0,0 };
    double columnWeights1[] = { 0,0,0,0,0,0,0,0,0 };
    gbl1.rowHeights = rowHeights1;
    gbl1.columnWidths = columnWidths1;
    gbl1.rowWeights = rowWeights1;
    gbl1.columnWeights = columnWeights1;

    // GridBagLayout declarations for 800x600 Pixels
    int rowHeights2[] = {24,24,24,72,24,72,24,72,24,72,24,72,24,24 };
    int columnWidths2[] = { 60,120,120,120,120,120,60 };
    double rowWeights2[] = { 0,0,0,0,0,0,0,0,0,0,0,0 };
    double columnWeights2[] = { 0,0,0,0,0,0,0,0,0 };
    gbl2.rowHeights = rowHeights2;
    gbl2.columnWidths = columnWidths2;
    gbl2.rowWeights = rowWeights2;
    gbl2.columnWeights = columnWeights2;

    // GridBagLayout declarations for 1024x768 Pixels
    int rowHeights3[] = {32,32,32,96,32,96,32,96,32,96,32,96,32,32 };
    int columnWidths3[] = { 80,160,160,160,160,160,80 };
    double rowWeights3[] ={ 0,0,0,0,0,0,0,0,0,0,0,0 };
    double columnWeights3[] = { 0,0,0,0,0,0,0,0,0 };
    gbl3.rowHeights = rowHeights3;
    gbl3.columnWidths = columnWidths3;
    gbl3.rowWeights = rowWeights3;
    gbl3.columnWeights = columnWeights3;

    // GridBagLayout declarations for 1280x1024 Pixels
    int rowHeights4[] = {40,40,40,120,40,120,40,120,40,120,40,120,40,40 };
    int columnWidths4[] = { 100,200,200,200,200,200,100 };
    double rowWeights4[] ={ 0,0,0,0,0,0,0,0,0,0,0,0 };
    double columnWeights4[] = { 0,0,0,0,0,0,0,0,0 };
    gbl4.rowHeights = rowHeights4;
    gbl4.columnWidths = columnWidths4;
    gbl4.rowWeights = rowWeights4;
    gbl4.columnWeights = columnWeights4;

    //GridBagConstraints declaration for all Screensizes
    resetConstraints();
    gbc.fill = GridBagConstraints.BOTH;
    gbc.weightx = 0.0;
    gbc.weighty = 0.0;
    gbc.anchor = GridBagConstraints.CENTER;
    gbc.insets = new Insets( 2, 2, 2, 2 );
    insertComponent( host1pan, 1, 2 );
    insertComponent( host2pan, 5, 2 );
    insertComponent( startbutton   , 3, 1 );
    insertComponent( stepbutleft   , 1, 1 );
    insertComponent( stepbutright  , 5, 1 );
    gbc.insets = new Insets( 0, 0, 0, 0  );
    insertComponent( closedpanel   , 3, 2 );
    insertComponent( listenpanel   , 3, 4 );
    insertComponent( synsentpanel  , 5, 6 );
    insertComponent( synrcvdpanel  , 1, 6 );
    insertComponent( estabpanel    , 3, 8 );
    insertComponent( closewaitpanel, 5, 8 );
    insertComponent( lastackpanel  , 5, 10 );
    insertComponent( finwait1panel , 1, 10 );
    insertComponent( finwait2panel , 1, 12);
    insertComponent( closingpanel  , 3, 10);
    insertComponent( timewaitpanel , 3, 12);
    insertComponent( closed2panel  , 5, 12);
    insertComponent( panel0to1  , 3, 3 );
    insertComponent( panel0to21 , 4, 3 );
    insertComponent( panel0to22 , 5, 4 );
    insertComponent( panel0to23 , 5, 5 );
    insertComponent( panel1to2  , 4, 5 );
    insertComponent( panel1to3  , 2, 5 );
    insertComponent( panel3to4  , 2, 7 );
    insertComponent( panel2to4  , 4, 7 );
    insertComponent( panel4to5  , 4, 8 );
    insertComponent( panel5to6  , 5, 9 );
    insertComponent( panel4to7  , 2, 9 );
    insertComponent( panel7to8 , 1, 11);
    insertComponent( panel7to9  , 2, 10);
    insertComponent( panel9to10 , 3, 11);
    insertComponent( panel8to10 , 2, 12);
    insertComponent( panel7to10 , 2, 11);
    insertComponent( panel10toright , 4, 12);
    insertComponent( panel6todown  , 5, 11 );
    insertComponent( panel2to31 , 2, 6 );
    insertComponent( panel2to32 , 3, 6 );
    insertComponent( panel2to33 , 4, 6 );
    insertComponent( panel3to71 , 1, 7 );
    insertComponent( panel3to72 , 1, 8 );
    insertComponent( panel3to73 , 1, 9 );
    //insertComponent( panel2toright  , 6, 6 );

    //set Startup-Frame
    //setLayout( gbl1 );
    setTitle( "TCP - Finite State Machine" );
    this .setBackground(Color.lightGray);
    changeScreenMan( 1 );
    validate();
    show();
    show_bool = true;
  }


/******************************************************************************
* Method: insertComponent
* Description: adds components on defined places using GridBagLayout.
* Parameters: comp is the current component, x,y define the position.
* Return Value: none
******************************************************************************/
  public void closeWindow() {
    this .dispose();
  }
/******************************************************************************
* Method: insertComponent
* Description: adds components on defined places using GridBagLayout.
* Parameters: comp is the current component, x,y define the position.
* Return Value: none
******************************************************************************/
  public void insertComponent( Component comp, int x, int y ){
    gbc.gridx = x;
    gbc.gridy = y;
    gbl1. setConstraints( comp, gbc );
    gbl2. setConstraints( comp, gbc );
    gbl3. setConstraints( comp, gbc );
    gbl4. setConstraints( comp, gbc );
    add( comp );
  }

/******************************************************************************
* Method: resetConstraints
* Description: resets all Constraints definitions.
* Parameters: none
* Return Value: none
******************************************************************************/
  public void resetConstraints(){
    gbc.gridx = 0;
    gbc.gridy = 0;
    gbc.gridwidth = 1;
    gbc.gridheight = 1;
    gbc.fill = gbc.BOTH;
    gbc.anchor = gbc.CENTER;
    gbc.insets = new Insets( 0, 0, 0, 0 );
    gbc.ipadx = 0;
    gbc.ipady = 0;
    gbc.weightx = 1.0;
    gbc.weighty = 1.0;
  }

/******************************************************************************
* Method: changeScreenAuto
* Description: changes the Screensize automatically to fixed sizes. There are
*   four given sizes.
* Parameters: none
* Return Value: none
******************************************************************************/
  public void changeScreenAuto(){
    int x, y, dx, dy;
    frameposition = this.location();
    framedimension = this.size();
    x = frameposition.x;
    y = frameposition.y;
    dx = framedimension.width;
    dy = framedimension.height;
    if ( ( dx < 720 ) || ( dy < 540 ) ){
      screenfactor = 1;
      resize( 650, 510 );
      setLayout( gbl1 );
      validate();
    }
    else if ( ( dx < 912 ) || ( dy < 684 ) ){
      screenfactor = 2;
      resize( 810, 630 );
      setLayout( gbl2 );
      validate();
    }
    else if ( ( dx < 1152 ) || ( dy < 896 ) ){
      screenfactor = 3;
      resize( 1034, 798 );
      setLayout( gbl3 );
      validate();
    }
    else {
      screenfactor = 4;
      resize( 1290, 1054 );
      setLayout( gbl4 );
      validate();
    }
    scaleComponents();
    this.move( x, y );
  }




/******************************************************************************
* Method: changeScreenMan
* Description: changes the screensize to the chosen menu value.
* Parameters: factor is the screensize-ID
* Return Value: none
******************************************************************************/
  public void changeScreenMan( int factor ){
    int x, y;
    frameposition = this.location();
    x = frameposition.x;
    y = frameposition.y;
    if ( factor == 1 ){
      screenfactor = 1;
      resize( 650, 510 );
      setLayout( gbl1 );
      validate();
    }
    else if ( factor == 2 ){
      screenfactor = 2;
      resize( 810, 630 );
      setLayout( gbl2 );
      validate();
    }
    else if ( factor == 3 ){
      screenfactor = 3;
      resize( 1034, 798 );
      setLayout( gbl3 );
      validate();
    }
    else if ( factor == 4 ){
      screenfactor = 4;
      resize( 1290, 1054 );
      setLayout( gbl4 );
      validate();
    }
    scaleComponents();
    this.move( x, y );
  }

/******************************************************************************
* Method: scaleComponents
* Description: scales all other components using the screensizefactor when
*   the screensize was changed.
* Parameters: none
* Return Value: none
******************************************************************************/
  public void scaleComponents(){
      closedpanel. changeSize(screenfactor);
      listenpanel. changeSize(screenfactor);
      synsentpanel. changeSize(screenfactor);
      synrcvdpanel. changeSize(screenfactor);
      estabpanel. changeSize(screenfactor);
      closewaitpanel. changeSize(screenfactor);
      lastackpanel. changeSize(screenfactor);
      finwait1panel. changeSize(screenfactor);
      finwait2panel. changeSize(screenfactor);
      closingpanel. changeSize(screenfactor);
      timewaitpanel. changeSize(screenfactor);
      closed2panel. changeSize(screenfactor);
      host1pan. changeSize(screenfactor);
      host2pan. changeSize(screenfactor);
      panel0to1. changeSize(screenfactor,2);
      panel0to21. changeSize(screenfactor,1);
      panel0to22. changeSize(screenfactor,5);
      panel0to23. changeSize(screenfactor,2);
      panel1to2. changeSize(screenfactor,1);
      panel1to3. changeSize(screenfactor,3);
      panel2to31. changeSize(screenfactor,4);
      panel2to32. changeSize(screenfactor,4);
      panel2to33. changeSize(screenfactor,4);
      panel3to4. changeSize(screenfactor,1);
      panel2to4. changeSize(screenfactor,3);
      panel4to5. changeSize(screenfactor,0);
      panel5to6. changeSize(screenfactor,2);
      panel4to7. changeSize(screenfactor,3);
      panel7to8. changeSize(screenfactor,2);
      panel7to9. changeSize(screenfactor,0);
      panel3to71. changeSize(screenfactor,2);
      panel3to72. changeSize(screenfactor,6);
      panel3to73. changeSize(screenfactor,2);
      panel9to10. changeSize(screenfactor,2);
      panel8to10. changeSize(screenfactor,0);
      panel7to10. changeSize(screenfactor,1);
      panel10toright. changeSize(screenfactor,0);
      panel6todown. changeSize(screenfactor,2);
      //panel2toright. changeSize(screenfactor,0);
      //panel0to2. changeSize(screenfactor);
    repaint();
    validate();
  }

/******************************************************************************
* Method: setBeginner
* Description:
* Parameters: none
* Return Value: none
******************************************************************************/
  public void setBeginner(){
  }
/******************************************************************************
* Method: setAdvanced
* Description:
* Parameters: none
* Return Value: none
******************************************************************************/
  public void setAdvanced(){
  }
/******************************************************************************
* Method: clickedStepLeftButton
* Description:
* Parameters: none
* Return Value: none
******************************************************************************/
  public void clickedStepLeftButton(){
    fsmHost1(counter1);
    counter1++;
    if (great) great = false;
    else great = true;
  }
/******************************************************************************
* Method: clickedStepRightButton
* Description:
* Parameters: none
* Return Value: none
******************************************************************************/
  public void clickedStepRightButton(){
    fsmHost2(counter2);
    counter2++;
    if (great) great = false;
    else great = true;
  }
/******************************************************************************
* Method:  clickedStartButton
* Description:
* Parameters: none
* Return Value: none
******************************************************************************/
  public void clickedStartButton(){
    if(startbutton.getLabel() == "Start" ) {
      startbutton. setLabel( "Restart" );
      stepbutleft.enable();
      stepbutright.enable();
      if(!host1pan.isValid()) insertComponent(host1pan, 1,2);
      if(!host2pan.isValid()) insertComponent(host2pan, 5,2);
      host1pan. changeSize( this, getHostKind(h1.t1.getStat()), 1);
      host2pan. changeSize( this, getHostKind(h2.t1.getStat()), 2);
      validate();
      if (great) great = false;
      else great = true;
      resizeFsmWindow();
    }
    else if (startbutton.getLabel() == "Restart" ) {
      startbutton. setLabel( "Start" );
      stepbutleft.disable();
      stepbutright.disable();
      this .remove(host1pan);
      this .remove(host2pan);
      if (great) great = false;
      else great = true;
      counter1=0;
      counter2=0;
      repaintAll();
      resizeFsmWindow();
      validate();
    }
  }
/******************************************************************************
* Method: getHostStat
* Description: gives the Kind of Host
* Parameters: the host
* Return Value: Integer
******************************************************************************/
  public int getHostKind( int cl_serv ){
    int kind;
    switch (cl_serv) {
        case 0:
            kind = 14;
            break;
        case 1:
            kind = 13;
            break;
        default:
            kind = 15;
    }
    return kind;
  }
/******************************************************************************
* Method: update
* Description:
* Parameters: the used graphic
* Return Value: none
******************************************************************************/
  public void update( Graphics g ){
    paint( g );
  }

/******************************************************************************
* Method: handleEvent
* Description: handles all Events for the menubar, slider, checkboxes, and
*   various mouseevents.
* Parameters: comp is the current component, x,y define the position.
* Return Value: none
******************************************************************************/
   public boolean handleEvent(Event event) {
    if ( event.id == Event.ACTION_EVENT && event.target == menuiquit ) {
      show_bool = false;
      //dispose();
      System.exit(1);
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == menuisize1 ) {
      changeScreenMan( 1 );
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == menuisize2 ) {
      changeScreenMan( 2 );
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == menuisize3 ) {
      changeScreenMan( 3 );
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == menuisize4 ) {
      changeScreenMan( 4 );
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == startbutton ) {
      clickedStartButton();
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == stepbutleft ) {
      clickedStepLeftButton();
      return true;
    }
    else if ( event.id == Event.ACTION_EVENT && event.target == stepbutright ) {
      clickedStepRightButton();
      return true;
    }
    else if ( event.id == 1004 ) {
      changeScreenAuto();
      return true;
    }
    if ( event.id == Event.MOUSE_DOWN && event.target == closedpanel ) {
      searchFsmHistElement("CLOSED2");
      return true;
    }
    if ( event.id == Event.MOUSE_DOWN && event.target == listenpanel ) {
      searchFsmHistElement("LISTEN");
      return true;
    }
    if ( event.id == Event.MOUSE_DOWN && event.target == synsentpanel ) {
      searchFsmHistElement("SYN_SENT");
      return true;
    }
    if ( event.id == Event.MOUSE_DOWN && event.target == synrcvdpanel ) {
      searchFsmHistElement("SYN_RCVD");
      return true;
    }
    if ( event.id == Event.MOUSE_DOWN && event.target == estabpanel ) {
      searchFsmHistElement("ESTABLISHED");
      return true;
    }
    if ( event.id == Event.MOUSE_DOWN && event.target == closewaitpanel ) {
      searchFsmHistElement("CLOSE_WAIT");
      return true;
    }
    if ( event.id == Event.MOUSE_DOWN && event.target == lastackpanel ) {
      searchFsmHistElement("LAST_ACK");
      return true;
    }
    if ( event.id == Event.MOUSE_DOWN && event.target == finwait1panel ) {
      searchFsmHistElement("FIN_WAIT_1");
      return true;
    }
     if ( event.id == Event.MOUSE_DOWN && event.target == finwait2panel ) {
      searchFsmHistElement("FIN_WAIT_2");
      return true;
    }
    if ( event.id == Event.MOUSE_DOWN && event.target == closingpanel ) {
      searchFsmHistElement("CLOSING");
      return true;
    }
    if ( event.id == Event.MOUSE_DOWN && event.target == timewaitpanel ) {
      searchFsmHistElement("TIME_WAIT");
      return true;
    }
    return super.handleEvent( event );
    }
/******************************************************************************
* Method: fsmHost1 
* Description: checks the String to highlight the panels and arrows 
* Parameters: int counter tells the position in the history 
* Return Value: none
******************************************************************************/
public void fsmHost1(int counter1) {
     length1 = h1.t1.history.size();
     if (length1>counter1) {
         newh1=(HTcpSegment) h1.t1.history.elementAt(counter1);
	 newh1.hl = 1;
	 fsmhist .addElement(newh1);
         statush1=newh1.State;
         if ((statush1.equals("CLOSED"))&(counter1==0)) {
            closedpanel. changeSize( this , 0, 1 );
            validate();
         }
         if ((statush1.equals("CLOSED"))&(counter1>2)) {
	   if (oldh1.State.equals("LAST_ACK")) {
              panel6todown. changeSize(screenfactor,2,1, newh1);
           }
           if (oldh1.State.equals("TIME_WAIT")) {
              panel10toright. changeSize(screenfactor,0,1, newh1);
           }
            closed2panel. changeSize( this , 0, 1 );
            validate();
         }
         if (statush1.equals("LISTEN")) {
            if (oldh1.State.equals("CLOSED")) {
                panel0to1. changeSize(screenfactor,2,1, newh1);
            }
            listenpanel.changeSize( this  , 1, 1 );
            validate();
         }
         if (statush1.equals("SYN_SENT")) {
            if (oldh1.State.equals("LISTEN")) panel1to2.changeSize(screenfactor,1,1, newh1);
            if (oldh1.State.equals("CLOSED")) {
                    panel0to21. changeSize(screenfactor,1,1, newh1);
	            panel0to22. changeSize(screenfactor,5,1, newh1);
	            panel0to23. changeSize(screenfactor,2,1, dummy);
            }
            synsentpanel. changeSize( this  , 2, 1 );
            validate();
         }
         if (statush1.equals("SYN_RCVD")) {
            if (oldh1.State.equals("LISTEN")) {
                panel1to3. changeSize(screenfactor,3,1, newh1);
            }
            synrcvdpanel. changeSize( this  , 3, 1 );
            validate();
         }
         if (statush1.equals("ESTABLISHED")) {
            if (oldh1.State.equals("SYN_SENT")) panel2to4.changeSize(screenfactor,3,1, newh1);
            if (oldh1.State.equals("SYN_RCVD")) panel3to4.changeSize(screenfactor,1,1, newh1);
            estabpanel. changeSize( this  , 4, 1 );
            validate();
         }
         if (statush1.equals("CLOSE_WAIT")) {
            if (oldh1.State.equals("ESTABLISHED")) panel4to5.changeSize(screenfactor,0,1, newh1);
            closewaitpanel. changeSize( this  , 5, 1 );
            validate();
         }
         if (statush1.equals("LAST_ACK")) {
            if (oldh1.State.equals("CLOSE_WAIT")) panel5to6.changeSize(screenfactor,2,1, newh1);
            lastackpanel. changeSize( this  , 6, 1 );
            validate();
         }
         if (statush1.equals("FIN_WAIT_1")) {
            if (oldh1.State.equals("ESTABLISHED")) panel4to7.changeSize(screenfactor,3,1, newh1);
	    if (oldh1.State.equals("SYN_RCVD")){
	      panel3to71. changeSize(screenfactor,2,1, newh1);
	      panel3to72. changeSize(screenfactor,6,1, dummy);
	      panel3to72. changeSize(screenfactor,2,1, dummy);
	    }
            finwait1panel. changeSize( this  , 7, 1 );
            validate();
         }
         if (statush1.equals("FIN_WAIT_2")) {
            if (oldh1.State.equals("FIN_WAIT_1")) panel7to8.changeSize(screenfactor,2,1, newh1);
            finwait2panel. changeSize( this  , 8, 1 );
            validate();
         }
         if (statush1.equals("CLOSING")) {
            if (oldh1.State.equals("FIN_WAIT_1")) panel7to9.changeSize(screenfactor,0,1, newh1);
            closingpanel. changeSize( this  , 9, 1 );
            validate();
         }
         if (statush1.equals("TIME_WAIT")) {
            if (oldh1.State.equals("FIN_WAIT_1")) panel7to10.changeSize(screenfactor,1,1, newh1);
            if (oldh1.State.equals("CLOSING")) panel9to10.changeSize(screenfactor,2,1, newh1);
            if (oldh1.State.equals("FIN_WAIT_2")) panel8to10.changeSize(screenfactor,0,1, newh1);
            timewaitpanel. changeSize( this  , 10, 1 );
            validate();
         }
         oldh1=newh1;
	 resizeFsmWindow();
     }
}
/******************************************************************************
* Method: fsmHost2
* Description: checks the String to highlight the panels and arrows 
* Parameters: counter tells the position in the history
* Return Value: none
******************************************************************************/
public void fsmHost2(int counter2) {
     length2 = h2.t1.history.size();
     if (length2>counter2) {
         newh2=(HTcpSegment) h2.t1.history.elementAt(counter2);
	 newh2.hl = 2;
	 fsmhist .addElement(newh2);
         statush2=newh2.State;
         if ((statush2.equals("CLOSED"))&(counter2==0)) {
            closedpanel. changeSize( this  , 0, 2 );
            validate();
         }
         if ((statush2.equals("CLOSED"))&(counter2>2)) {
	   if (oldh2.State.equals("LAST_ACK")) {
               panel6todown. changeSize(screenfactor,2,2,newh2);
            }
            if (oldh2.State.equals("TIME_WAIT")) {
               panel10toright. changeSize(screenfactor,0,2,newh2);
            }
            closed2panel. changeSize( this , 0, 2 );
            validate();
         }
         if (statush2.equals("LISTEN")) {
	   if (oldh2.State.equals("CLOSED")) {
                panel0to1. changeSize(screenfactor,2,2, newh2);
            }
            listenpanel. changeSize( this  , 1, 2 );
            validate();
         }
         if (statush2.equals("SYN_SENT")) {
            if (oldh2.State.equals("LISTEN")) panel1to2.changeSize(screenfactor,1,2, newh2);
            if (oldh2.State.equals("CLOSED")) {
    	      panel0to21. changeSize(screenfactor,1,2, newh2);
    	      panel0to22. changeSize(screenfactor,5,2, newh2);
    	      panel0to23. changeSize(screenfactor,2,2, newh2);
    	    }
            synsentpanel. changeSize( this  , 2, 2 );
            validate();
         }
         if (statush2.equals("SYN_RCVD")) {
	   if (oldh2.State.equals("LISTEN")) {
                panel1to3. changeSize(screenfactor,3,2, newh2);
	    }
            synrcvdpanel. changeSize( this  , 3, 2 );
            validate();
         }
         if (statush2.equals("ESTABLISHED")) {
            if (oldh2.State.equals("SYN_SENT")) panel2to4.changeSize(screenfactor,3,2, newh2);
            if (oldh2.State.equals("SYN_RCVD")) panel3to4.changeSize(screenfactor,1,2, newh2);
            estabpanel. changeSize( this  , 4, 2);
            validate();
         }
         if (statush2.equals("CLOSE_WAIT")) {
            if (oldh2.State.equals("ESTABLISHED")) panel4to5.changeSize(screenfactor,0,2, newh2);
            closewaitpanel. changeSize( this  , 5, 2 );
            validate();
         }
         if (statush2.equals("LAST_ACK")) {
            if (oldh2.State.equals("CLOSE_WAIT")) panel5to6.changeSize(screenfactor,2,2, newh2);
            lastackpanel. changeSize( this  , 6, 2 );
            validate();
         }
         if (statush2.equals("FIN_WAIT_1")) {
            if (oldh2.State.equals("ESTABLISHED")) panel4to7.changeSize(screenfactor,3,2, newh2);
	    if (oldh2.State.equals("SYN_RCVD")){
	      panel3to71. changeSize(screenfactor,2,1, newh2);
	      panel3to72. changeSize(screenfactor,6,1, dummy);
	      panel3to72. changeSize(screenfactor,2,1, dummy);
	    }
            finwait1panel. changeSize( this  , 7, 2 );
            validate();
         }
         if (statush2.equals("FIN_WAIT_2")) {
            if (oldh2.State.equals("FIN_WAIT_1")) panel7to8.changeSize(screenfactor,2,2, newh2);
            finwait2panel. changeSize( this  , 8, 2 );
            validate();
         }
         if (statush2.equals("CLOSING")) {
            if (oldh2.State.equals("FIN_WAIT_1")) panel7to9.changeSize(screenfactor,0,2, newh2);
            closingpanel. changeSize( this  , 9, 2 );
            validate();
         }
         if (statush2.equals("TIME_WAIT")) {
            if (oldh2.State.equals("FIN_WAIT_1")) panel7to10.changeSize(screenfactor,1,2, newh2);
            if (oldh2.State.equals("CLOSING")) panel9to10.changeSize(screenfactor,2,2, newh2);
            if (oldh2.State.equals("FIN_WAIT_2")) panel8to10.changeSize(screenfactor,0,2, newh2);
            timewaitpanel. changeSize( this  , 10, 2 );
            validate();
         }
         oldh2=newh2;
	 resizeFsmWindow();
     }
}
/******************************************************************************
* Method: searchFsmHistElement
* Description: checks for the right HistorySegment to display it
* Parameters: String of the Panel
* Return Value: none
******************************************************************************/
  public void resizeFsmWindow(){
         if(great){
             switch(screenfactor) {
                case 1:
                    resize( 650, 510 );
                    break;
                case 2:
                    resize( 810, 650 );
                    break;
                case 3:
                    resize( 1034, 798 );
                    break;
                case 4:
                    resize( 1290, 1054 );
                    break;
             }
         }
         else {
             switch(screenfactor) {
                case 1:
                    resize( 651, 511 );
                    break;
                case 2:
                    resize( 811, 651 );
                    break;
                case 3:
                    resize( 1035, 799 );
                    break;
                case 4:
                    resize( 1291, 1055 );
                    break;
             }
         }
  }

/******************************************************************************
* Method: searchFsmHistElement
* Description: checks for the right HistorySegment to display it
* Parameters: String of the Panel
* Return Value: none
******************************************************************************/
  public void searchFsmHistElement( String fsmstate ) {
    int fsmlength = fsmhist.size();
    for (int c = 0; c< fsmlength; c++) {
      fsmseg = (HTcpSegment)fsmhist.elementAt(c);
      if(fsmseg.State.equals(fsmstate)){
	switch (fsmseg.hl) {
	case 1:
	  if (fsmseg.State != oldseg.State){
	    Header h1 = new Header();
	    h1.Header(fsmstate+" of Host1",fsmseg);
	    h1. enter();
	  }
	  break;
	case 2:
	  if (fsmseg.State != oldseg.State){
	    Header h2 = new Header();
	    h2.Header(fsmstate+" of Host2",fsmseg);
	    h2. enter();
	  }
	  break;
	}// END of switch (fsmseg.hl)
      }// END if()
      oldseg = fsmseg;
    }// END for (;;)
  }// END of method searchFsmHistElement
/******************************************************************************
* Method: repaintAll()
* Description: gives the Kind of Host
* Parameters: the host
* Return Value: Integer
******************************************************************************/
public void repaintAll() {
      closedpanel.    changeSize( this , 0, 0 );
      listenpanel.    changeSize( this , 1, 0 );
      synsentpanel.   changeSize( this , 2, 0 );
      synrcvdpanel.   changeSize( this , 3, 0 );
      estabpanel.     changeSize( this , 4, 0 );
      closewaitpanel. changeSize( this , 5, 0 );
      lastackpanel.   changeSize( this , 6, 0 );
      finwait1panel.  changeSize( this , 7, 0 );
      finwait2panel.  changeSize( this , 8, 0 );
      closingpanel.   changeSize( this , 9, 0 );
      timewaitpanel.  changeSize( this , 10, 0 );
      closed2panel.   changeSize( this , 0, 0 );
      host1pan.   changeSize( this,15,0);
      host2pan.   changeSize( this,15,0);
      //*******************************************
      panel0to1.  changeSize(screenfactor,2,0,dummy);
      panel0to21. changeSize(screenfactor,1,0,dummy);
      panel0to22. changeSize(screenfactor,5,0,dummy);
      panel0to23. changeSize(screenfactor,2,0,dummy);
      panel1to2.  changeSize(screenfactor,1,0,dummy);
      panel1to3.  changeSize(screenfactor,3,0,dummy);
      panel2to31. changeSize(screenfactor,4,0,dummy);
      panel2to32. changeSize(screenfactor,4,0,dummy);
      panel2to33. changeSize(screenfactor,4,0,dummy);
      panel3to4.  changeSize(screenfactor,1,0,dummy);
      panel2to4.  changeSize(screenfactor,3,0,dummy);
      panel4to5.  changeSize(screenfactor,0,0,dummy);
      panel5to6.  changeSize(screenfactor,2,0,dummy);
      panel4to7.  changeSize(screenfactor,3,0,dummy);
      panel3to71. changeSize(screenfactor,2,0,dummy);
      panel3to72. changeSize(screenfactor,6,0,dummy);
      panel3to73. changeSize(screenfactor,2,0,dummy);
      panel7to8.  changeSize(screenfactor,2,0,dummy);
      panel7to9.  changeSize(screenfactor,0,0,dummy);
      panel9to10. changeSize(screenfactor,2,0,dummy);
      panel8to10. changeSize(screenfactor,0,0,dummy);
      panel7to10. changeSize(screenfactor,1,0,dummy);
      panel10toright. changeSize(screenfactor,0,0,dummy);
      panel6todown.   changeSize(screenfactor,2,0,dummy);
      //panel2toright. changeSize(screenfactor,0,0,dummy);
      //repaint();
      validate();
}//END of method repaintAll()

}// END of FSMWindow











